/** Datentyp fr Knoten eines Suchbaums, deren Werte 
 *  verglichen werden knnen.
 * @see Suchbaum
 * @see VergleichbarUndOrd
 * @author Antje Nowack
 */


/* Umgebung : JDK 1.3, Linux
 * Erstellt : 28. 12.2001 
 * Letzte Aenderung: 7. 1. 2002
 */


public class Knoten {
    
    private VergleichbarUndOrd wert;
    private Knoten links, rechts; //Knoten ist eine rekursive Datenstruktur.
    
    /** erzeugt einen neuen Knoten ohne Nachfolger.
     *   @param wert Wert, den der neue Knoten erhalten soll
     */
    public Knoten (VergleichbarUndOrd wert) {
	this.wert = wert;
	links = null;
        rechts = null;
    }
    
    /** erzeugt einen neuen Knoten mit Nachfolgern.
     *   @param wert Wert, den der neue Knoten erhalten soll
     *   @param links linker Teilbaum
     *   @param rechts rechter Teilbaum
     */
    public Knoten (VergleichbarUndOrd wert, Knoten links, Knoten rechts) {
	this.wert = wert;
	this.links = links;
        this.rechts = rechts;
    }
    
    /** @return Wert des Knotens
     */
    public VergleichbarUndOrd getWert () {
	return wert;
    }
    
    /** @param wert Wert, den der Knoten erhalten soll
     */	
    public void setWert (VergleichbarUndOrd wert) {
	this.wert = wert;
    }

    /** @return linker Nachfolger des Knotens
     */
    public Knoten getLeft () {
	return links;
    }
    
    /** @return rechter Nachfolger des Knotens
     */
    public Knoten getRight () {
	return rechts;
    }

    /** @param links linker Nachfolger, den der Knoten erhalten soll
     */	
    public void setLeft (Knoten links) {
	this.links = links;
    }
    
    /** @param rechts rechter Nachfolger, den der Knoten erhalten soll
     */	
    public void setRight (Knoten rechts) {
	this.rechts = rechts;
    }

    public String toString () {
	return wert.toString();
    }


    /** vergleicht zwei Knoten inhaltlich nach ihrem Wert
     *  @param zuvergleichen der Knoten, mit dem 
     *         das aktuelle Knoten verglichen werden soll
     *  @return true, falls die Werte der beiden Knoten 
     *          inhaltlich gleich sind und sonst false
     */
    public boolean gleich (Knoten zuvergleichen) {
	
	return wert.gleich (zuvergleichen.wert);

    }
    
}




