/** Klasse fr rationale Zahlen in Bruchdarstellung.
 *  @author Jrgen Giesl, Antje Nowack (Ergaenzungen)
 */

public class Bruch extends Zahl {


    /** Attribute fr den Zhler und den Nenner des Bruchs
     */
    private int zaehler, nenner;

    /** generiert einen Bruch durch Eingabe des Benutzers
     */
    public Bruch () {
	aenderung();
    }
   


    /** generiert einen Bruch mit vorgegebenem Zhler und Nenner. Falls der vorgegebene
     *  Nenner 0 ist, wird jedoch der Benutzer nach neuen Werten fr Zhler und Nenner
     *  gefragt.
     *  @param zaehler der Zhler des neuen Bruchs
     *  @param nenner  der Nenner des neuen Bruchs
     */
    public Bruch (int zaehler, int nenner) {

	this.zaehler = zaehler;
	this.nenner = nenner;	
	
	if (nenner == 0) {
	    System.out.println("Unzulssiger Bruch!");
	    aenderung ();
	}
	
    }

    /** liest einen Bruch von der Tastatur ein
     *  und ndert den aktuellen Bruch entsprechend
     */
    public void aenderung () {

	System.out.print ("Bitte geben Sie den Zhler des Bruchs ein: ");
	zaehler = IO.Eingabe ();

	do {
	    System.out.print ("Bitte geben Sie den Nenner des Bruchs ein: ");
	    nenner = IO.Eingabe ();
	    if (nenner == 0) System.out.println ("Der Nenner darf nicht 0 sein.");
	}
	while (nenner == 0);

    }


    /** vergleicht zwei Brche nach ihrem Wert.
     *  @param zuvergleichen das Objekt Bruch, 
     *         mit dem der aktuelle Bruch verglichen werden soll
     *  @return true, falls die beiden Brche inhaltlich gleich sind und sonst false;
     *   falls "zuvergleichen" kein Bruch ist, wird eine Fehlermeldung ausgegeben und 
     *   das Ergebnis ist ebenfalls false.
     */
    public boolean gleich (Vergleichbar zuvergleichen) {

	Bruch b;

	if (zuvergleichen instanceof Bruch) {
	    b = (Bruch) zuvergleichen;
	    return (zaehler * b.nenner == b.zaehler * nenner);
	}
	else {
	    System.out.println ("Es wurden keine Brche verglichen.");
	    return false;
	}

    }


    /** vergleicht zwei Brueche der ueblichen Ordnungrelation
     *  @param zuvergleichen der Bruch, mit dem 
     *         der aktuelle Bruch verglichen werden soll
     *  @return true gdw.der aktuelle Bruch groesser ist als der uebergebene
     */
    public boolean groesser (Ord b) {
      // Fehlermeldung, wenn kein Bruch uebergeben wurde
      if (! (b instanceof Bruch)) {
        System.out.println("Es wurde kein gueltiges Objekt vom Typ Bruch verglichen. ");
        return false;
      }
      else {
         Bruch rat = (Bruch) b;
         if  (rat.nenner * nenner == 0) {
            System.out.println("Es wurden keine gueltigen Brueche verglichen. ");
            return false;
         }
         else 
           // keine Vertauschung der Seiten der Ungleichung bei Multiplation
           // jeweils mit den Nennern
           if ((rat.nenner > 0 & nenner >  0) | (rat.nenner < 0 & nenner <  0)) 
                return (rat.zaehler * nenner < rat.nenner * zaehler);
	 // Vertauschung
           else
              return (rat.zaehler * nenner < rat.nenner * zaehler);              
      }
    }


    /** rundet den aktuellen Bruch auf die nchstkleinere ganze Zahl ab.
     *  @return die abgerundete ganze Zahl
     */
    protected int runde () {

	return zaehler / nenner;

    }

    /** berfhrt den Bruch in einen String.
     *  @return String des Bruchs sowie Information ber die nchstkleinere
     *          ganze Zahl
     */

    public String toString () {
	return zaehler + "/" + nenner;
	//return zaehler + "/" + nenner + " (" + rundungsinformation() + ")";

    }

}
