/** Klasse fr rationale Zahlen in Bruchdarstellung.
 *  @author Jrgen Giesl
 */
public class Bruch extends Zahl {


    /** Attribute fr den Zhler und den Nenner des Bruchs
     */
    private int zaehler, nenner;

    /** generiert einen Bruch durch Eingabe des Benutzers
     */
    public Bruch () {
	aenderung();
    }
   


    /** generiert einen Bruch mit vorgegebenem Zhler und Nenner. Falls der vorgegebene
     *  Nenner 0 ist, wird jedoch der Benutzer nach neuen Werten fr Zhler und Nenner
     *  gefragt.
     *  @param zaehler der Zhler des neuen Bruchs
     *  @param nenner  der Nenner des neuen Bruchs
     */
    public Bruch (int zaehler, int nenner) {

	this.zaehler = zaehler;
	this.nenner = nenner;	
	
	if (nenner == 0) {
	    System.out.println("Unzulssiger Bruch!");
	    aenderung ();
	}
	
    }

    /** liest einen Bruch von der Tastatur ein
     *  und ndert den aktuellen Bruch entsprechend
     */
    public void aenderung () {

	System.out.print ("Bitte geben Sie den Zhler des Bruchs ein: ");
	zaehler = IO.Eingabe ();

	do {
	    System.out.print ("Bitte geben Sie den Nenner des Bruchs ein: ");
	    nenner = IO.Eingabe ();
	    if (nenner == 0) System.out.println ("Der Nenner darf nicht 0 sein.");
	}
	while (nenner == 0);

    }


    /** vergleicht zwei Brche nach ihrem Wert.
     *  @param zuvergleichen das Objekt Bruch, 
     *         mit dem der aktuelle Bruch verglichen werden soll
     *  @return true, falls die beiden Brche inhaltlich gleich sind und sonst false;
     *   falls "zuvergleichen" kein Bruch ist, wird eine Fehlermeldung ausgegeben und 
     *   das Ergebnis ist ebenfalls false.
     */
    public boolean gleich (Vergleichbar zuvergleichen) {

	Bruch b;

	if (zuvergleichen instanceof Bruch) {
	    b = (Bruch) zuvergleichen;
	    return (zaehler * b.nenner == b.zaehler * nenner);
	}
	else {
	    System.out.println ("Es wurden keine Brche verglichen.");
	    return false;
	}

    }

    /** rundet den aktuellen Bruch auf die nchstkleinere ganze Zahl ab.
     *  @return die abgerundete ganze Zahl
     */
    protected int runde () {

	return zaehler / nenner;

    }

    /** berfhrt den Bruch in einen String.
     *  @return String des Bruchs sowie Information ber die nchstkleinere
     *          ganze Zahl
     */

    public String toString () {
	
	return zaehler + "/" + nenner + " (" + rundungsinformation() + ")";

    }

}
