/** Klasse fuer nicht-leere Listen
 *  @author Antje Nowack
 *  @see Liste
 *  @see NichtLeereListe
 */


/* Umgebung : JDK 1.3, Linux
 * Erstellt : 28. 12.2001 
 * Letzte Aenderung: 7. 1. 2002
 */

public class NichtLeereListe extends Liste {
  
  // erster Wert in der Liste
  private Vergleichbar wert;

  //Rest
  private Liste next;

  /** Liefert eine Liste der Laenge 1
   *  @parameter n der Wert, den die Liste enthalten soll
   *  @return Liste der Laenge 1 mit dem uebergebenen Wert
   */   
  NichtLeereListe (Vergleichbar n) {
    wert = n;
    next = null;
  }

  /** liefert einen booleschen Wert zurueck
   *  @parameter k der Wert, fuer den ueberprueft werden soll, ob er
   *             in der Liste, fuer die die Methode aufgerufen wird, 
   *             enthalten ist
   *  @return true gdw. der uebergeben Wert in der Liste enthalten ist
   */
  public boolean enthalten (Vergleichbar k) {
    if (wert.gleich(k)) return true;
    else {
       if (next == null) return false;
       else return next.enthalten(k);
    }
  }
 

  /** liefert eine Liste zurueck
   *  @parameter l die Liste, die an die Liste, fuer die die Methode aufgerufen 
   *             wird, angehanengt werden soll
   *  @return Liste, die durch Anhaengen der als Parameter uebergebenen 
   *          Liste an die Liste, fuer die die Methode aufgerufen wird, 
   *          entsteht
   */  
  public Liste append (Liste l) {
    if (!(l instanceof LeereListe)) {
       NichtLeereListe h = this;
       if (h.next == null)  {
         h.next = l;
         return h;
       }  
       else {
         h.next = (h.next).append(l);
         return h;
       }
     }
    // wenn die uebergebene Liste leer ist, wird die aktuelle 
    // Liste zurueckgeliefert
    else return this;
  }


  /** liefert eine Liste zurueck
   *  @parameter k, der Wert, der aus der Liste, fuer die die Methode 
   *             aufgerufen wird, geloescht werden soll
   *  @return Liste, die durch Loeschen des ersten Auftretens des als 
   *          Parameter uebergebenen Wertes an die Liste, fuer die die 
   *          Methode aufgerufen wird, entsteht
   */

  public Liste loesche (Vergleichbar k) {
     if (! (next == null)) {
       if (wert.gleich (k)) return next;
       else return (new NichtLeereListe (wert)).append (next.loesche (k));
     }
     else {
       if (wert.gleich (k)) return new LeereListe ();
       else return this;
     }
  }
 

  
 
} 
