/** Abstrakte Klasse Liste
 *  @author Antje Nowack
 *  @see LeereListe
 *  @see NichtLeereListe
 */


/* Umgebung : JDK 1.3, Linux
 * Erstellt : 28. 12.2001 
 * Letzte Aenderung: 7. 1. 2002
 */

public abstract class Liste {

  /** Abstrakte Methode; liefert eine Liste zurueck
   *  @parameter l die Liste, die an die Liste, fuer die die Methode aufgerufen 
   *             wird, angehanengt werden soll
   *  @return Liste, die durch Anhaengen der als Parameter uebergebenen 
   *          Liste an die Liste, fuer die die Methode aufgerufen wird, 
   *          entsteht
   */
  public abstract Liste append (Liste l);

  /** Abstrakte Methode; liefert eine Liste zurueck
   *  @parameter k, der Wert, der aus der Liste, fuer die die Methode 
   *             aufgerufen wird, geloescht werden soll
   *  @return Liste, die durch Loeschen des ersten Auftretens des als 
   *          Parameter uebergebenen Wertes an die Liste, fuer die die 
   *          Methode aufgerufen wird, entsteht
   */
  public abstract Liste loesche (Vergleichbar k);

  /** Abstrakte Methode; liefert einen booleschen Wert zurueck
   *  @parameter k der Wert, fuer den ueberprueft werden soll, ob er
   *             in der Liste, fuer die die Methode aufgerufen wird, 
   *             enthalten ist
   *  @return true gdw. der uebergeben Wert in der Liste enthalten ist
   */
  abstract boolean enthalten (Vergleichbar k);
  
  /** liefert eine Liste zurueck
   *  @parameter k, der Wert, der in die Liste, fuer die die Methode 
   *             aufgerufen wird, vorne eingefuegt werden soll
   *  @return Liste, die durch Einfuegen des als Parameter uebergebenen 
   *          Wertes vorne in die Liste, fuer die die Methode aufgerufen wird,
   *          entsteht
   */
  public Liste fuegeVorneEin (Vergleichbar k) {
    // Liefert Liste zurueck, die entsteht durch Anhaengen der einelementigen
    // Liste mit dem uebeergebenen Parameter
    return this.append (new NichtLeereListe (k));
  }

  /** liefert eine Liste zurueck
   *  @parameter k, der Wert, der in die Liste, fuer die die Methode 
   *             aufgerufen wird, hinten eingefuegt werden soll
   *  @return Liste, die durch Einfuegen des als Parameter uebergebenen 
   *          Wertes hinten in die Liste, fuer die die Methode aufgerufen wird,
   *          entsteht
   */
  public Liste fuegeHintenEin (Vergleichbar k) {
    return (new NichtLeereListe (k)).append(this);
  }

  
}
