package kontoverwaltung.liste;

/** Interface fr Datentypen, deren Objekte auf 
 *  <em>inhaltliche</em>  Gleichheit verglichen werden knnen.
 *  @author Jrgen Giesl
 */
public interface Vergleichbar {
    
    /** vergleicht zwei Objekte inhaltlich
     *  @param zuvergleichen das Objekt, mit dem 
     *         das aktuelle Objekt verglichen werden soll
     *  @return true, falls die Objekte inhaltlich gleich sind und sonst false
     */
    boolean gleich (Vergleichbar zuvergleichen);
    
    /** vergleicht zwei Objekte inhaltlich
     *  @param zuvergleichen das Objekt, mit dem 
     *         das aktuelle Objekt verglichen werden soll
     *  @return true, falls das aktuelle Objekt inhaltlich kleiner ist als das bergebene, sonst false
     */
    boolean kleiner(Vergleichbar zuvergleichen);

}


