package kontoverwaltung.konto;

import kontoverwaltung.liste.Vergleichbar;

/* Die Klasse realisiert ein Datum und stellt spezifische Attribute
 * und Operationen (Methoden) fr ein Datum bereit.
 * Autor: Thomas von der Maen
 * Umgebung: JDK 1.3.1, Windows 2000
 * Erstellt: 14.01.2002
 */

public class Datum implements Vergleichbar {
	
	private int tag = 0;
	private int monat = 0;
	private int jahr = 0;
	
	/* Setzt den Tag des Datums */
	public void setTag(int t) {
		tag = t;
	}
	
	/* Gibt den Tag des Datums zurck */
	public int getTag() {
		return tag;
	}
	
	/* Setzt den Monat des Datums */
	public void setMonat(int m) {
		monat = m;
	}
	
	/* Gibt den Monat des Datums zurck */
	public int getMonat() {
		return monat;
	}
	
	/* Setzt das Jahr des Datums */
	public void setJahr(int j) {
		jahr = j;
	}
	
	/* Gibt das Jahr des Datums zurck */
	public int getJahr() {
		return jahr;
	}
	
	/* Gibt das Datum in einer String-Darstellung zurck */
	public String toString() {
		String d = tag + "." + monat + "." + jahr;
		return d;		
	}
	
	/* Prft ob das aktuelle Datumsobjekt inhaltsgleich mit dem bergebenen Datum ist
	 * @param zu vergleichendes Datum
	 * @param true, wenn aktuelles Datum inhaltsgleich zum bergebenen Datum ist, sonst false
	 */
	public boolean gleich(Vergleichbar zuvergleichen) {
		if (zuvergleichen instanceof Datum) {
			Datum d = (Datum)zuvergleichen;
			if (this.tag == d.tag && this.monat == d.monat && this.jahr == d.jahr) {
              	return true;
          }
          else {
          	return false;
          }
        }
        else
        	return false;
     }
     
     /* Prft, ob das aktuelle Datum vor dem zu vergleichenden ist
      * @param zu vergleichendes Datum
      * @return true wenn das Aktuelle Datum zeitlich vor dem bergebenden Datum liegt
      */
     public boolean kleiner(Vergleichbar zuvergleichen) {
     	if (zuvergleichen instanceof Datum) {
     		Datum d = (Datum)zuvergleichen;
     		if (this.getJahr() > d.getJahr()) {
				return false;
			}
			else if (this.getJahr() < d.getJahr()) {
				return true;
			}
			else {
				/* Prfe das Jahr */
				if (this.getMonat() > d.getMonat()) {
					return false;
				}
				/* Prfe den Monat */
				else if (this.getMonat() < d.getMonat()) {
					return true;
				}
				else {
					/* Prfe den Tag */
					if (this.getTag() > d.getTag()) {
						return false;
					}
					else {
						return true;
					}
				}
			}
     	}
     	else
     		return false;
     }
}