package kontoverwaltung.konto;

/* Die Klasse realisiert ein einfach-verkette Liste um Buchungselemente
 * zu speichern. Ebenso werden Operationen (Methoden) fr die Arbeit auf
 * dieser Liste zur Verfgung gestellt. Einige Operationen werden an
 * die allgemeine Liste delegiert.
 * Autor: Thomas von der Maen
 * Umgebung: JDK 1.3.1, Windows 2000
 * Erstellt: 14.01.2002
 */
 
import kontoverwaltung.liste.*;

public class Buchungsliste {
	
	// Enthlt die allgemeine Liste
	private Liste bliste;
	private int anzahlBuchungen;
	
	/* Standardkonstrukor */
	public Buchungsliste() {
		bliste = new Liste();
		anzahlBuchungen = 0;
	}
	
	/* Fgt eine Buchung in die Liste ein.
	 * @param Buchung
	 */
	public void fuegeSortiertEin(Buchung b) {
		// Delegiere an allgemeine Liste
		bliste.fuegeSortiertEin(b);
		anzahlBuchungen = anzahlBuchungen + 1;
	}
	
	/* Such eine Buchung und liefert das Listenelement zurck
	 * @param Buchung
	 * @return Listenelement, welches die Buchung enthlt (oder null)
	 */
	public Element suche(Buchung b) {
		return bliste.suche(b);
	}
	
	/* Liefert die Anzahl der gespeicherten Buchungen in der Liste
	 * @return Anzahl der Buchungen in der Liste
	 */
	public int getAnzahlBuchungen() {
		return anzahlBuchungen;
	}
	
	/* Berechnet den Saldo mittels einer Hilfsmethode
	 * @return Saldo
	 */
	public double berechneSaldo() {
		double saldo = 0.0;
		Element e = bliste.getKopf();
		while (e != null) {
			Buchung b = (Buchung)e.getWert();
			saldo = saldo + b.getBetrag();
			e = e.getNext();
		}		
		return saldo;
	}
			
	/* 	Gibt die gespeicherten Buchungen von vorne nach hinten mittels einer Hilfsmethode aus */
	public void drucke() {
		bliste.drucke();
	}
}