package kontoverwaltung.konto;
/* Die Klasse realisiert eine Buchung und stellt spezifische Attribute
 * und Operationen (Methoden) fr eine Buchung bereit.
 * Autor: Thomas von der Maen
 * Umgebung: JDK 1.3.1, Windows 2000
 * Erstellt: 14.01.2002
 */
 
import kontoverwaltung.liste.Vergleichbar;

public class Buchung implements Vergleichbar {
	
	private String beschreibung = "";
	private double betrag = 0.0;
	private Datum datum = new Datum();
	
	/* Setzt die Beschreibung der Buchung auf den String b */
	public void setBeschreibung(String b) {
		beschreibung = b;
	}
	
	/* Liefert die Beschreibung der Buchung zurck */
	public String getBeschreibung() {
		return beschreibung;
	}
	
	/* Setzt den Betrag der Buchung auf den bergebenen Wert b */
	public void setBetrag(double b) {
		betrag = b;
	}
	
	/* Liefert den Betrag der Buchung zurck */
	public double getBetrag() {
		return betrag;
	}
	
	/* Setzt das Datum der Buchung auf das Datum d */
	public void setDatum(Datum d) {
		datum = d;
	}
	
	/* Liefert das Datum der Buchung zurck */
	public Datum getDatum() {
		return datum;
	}
	
	public String toString() {
		return ((this.getDatum()).toString() + " " + this.getBeschreibung() + " " + this.getBetrag() + "\n");
	}
	
	/* Prft zwei Buchungen auf ihre Inhaltsgleichheit */
	public boolean gleich(Vergleichbar zuvergleichen) {
		if (zuvergleichen instanceof Buchung) {
			Buchung b = (Buchung)zuvergleichen;
			// Vergleiche Beschreibung, Betrag und Datum
			if ((this.beschreibung.equals(b.beschreibung)) &&
				(this.betrag == b.betrag) &&
				(this.datum.gleich(b.datum))) {
					return true;
			}
			else {
				return false;
			}
		}
		else {
			System.out.println("Kein Buchungsvergleich!");
			return false;
		}
	}
	
	/* Prft ob das aktuelle Buchungsobjekt zeitlich vor dem bergebenen Buchungsobjekt liegt */
	public boolean kleiner(Vergleichbar zuvergleichen) {
		if (zuvergleichen instanceof Buchung) {
			Buchung b = (Buchung)zuvergleichen;
			// Prft, das Datum der beiden Buchungen
			if (this.datum.kleiner(b.datum)) {
				return true;
			}
			else {
				return false;
			}
		}
		else {
			System.out.println("Kein Buchungsvergleich!");
			return false;
		}
	}
}