package kontoverwaltung;

import kontoverwaltung.konto.*;
import kontoverwaltung.liste.*;

/* Die Klasse realisiert eine Kontoverwaltung und benutzt dazu
 * die Klassen Konto, Buchung und Datum
 * Autor: Thomas von der Maen
 * Umgebung: JDK 1.3.1, Windows 2000
 * Erstellt: 14.01.2002
 */

public class Kontoverwaltung {

	public static Kontoliste konten = new Kontoliste();
	
	/* Stellt das Auswahlmenue auf dem Bildschirm dar */
	public static void druckeMenu() {
		System.out.println("*** Kontoverwaltung ***");
		System.out.println("1) Konto eroeffnen");
		System.out.println("2) Setze aktives Konto");
		System.out.println("3) Buchung hinzufuegen");
		System.out.println("4) Kontoauszug");
		System.out.println("5) Anzahl verwalteter Konten ausgeben");
		System.out.println("6) Beenden");
	}

	/* Listet alle verwalteten Konten auf */
	public static void listeKonten() {
		System.out.println("*** Verwaltete Konten ***");
		konten.drucke();
	}

	public static void main (String[] args) {
		
		Konto aktivesKonto = null;
		/* Menauswahl */
		int auswahl = 0;
		/* Hilfsvariablen */
		int b;
		int index = 0;
		String dummy;
						
		/* Zeige das Menue solange, bis das Programm beendet wird */
		while (auswahl != 6) {
			druckeMenu();
			auswahl = IO.Eingabe();
			switch (auswahl) {
				case 1: { /* Fragt den Benutzer nach den neuen Konto-Daten */
							Konto konto = new Konto();
				          	System.out.print("Geben Sie den Inhaber an: ");
				          	dummy = IO.TextEingabe();
				          	konto.setInhaber(dummy);
				          	System.out.print("Geben Sie die BLZ an: ");
				          	dummy = IO.TextEingabe();
				          	konto.setBLZ(dummy);
				          	System.out.print("Geben Sie die Kontonummer an: ");
				          	dummy = IO.TextEingabe();
				          	konto.setKontonr(dummy);
					        konten.fuegeVorneEin(konto);
					        aktivesKonto = konto;			     
				        } break;
				case 2: { /* Listet alle gespeicherten Konten auf und lt den Benutzer
						   das aktive Konto auswhlen */
							listeKonten();
					        System.out.print("Waehlen Sie das aktuelle Konto: ");
					        index = IO.Eingabe();
					        if (index > 0 && index <= Konto.anzahlKonten()) {
					        	aktivesKonto = konten.kontoAnPosition(index);
					        }
					        else {
					        	System.out.println("Keine gueltige Auswahl!");
					        }
				        } break;
				case 3: { /* Liest eine neue Buchung durch den Benutzer ein */
						Buchung buchung = new Buchung();
						Datum datum = new Datum();
				          System.out.print("Geben Sie den Buchungstext an: ");
				          dummy = IO.TextEingabe();
				          buchung.setBeschreibung(dummy);
				          System.out.print("Geben Sie den Betrag an: ");
				          b = IO.Eingabe();
				          buchung.setBetrag(b);
				          System.out.print("Geben Sie den Tag an: ");
				          b = IO.Eingabe();
				          datum.setTag(b);
				          System.out.print("Geben Sie den Monat an: ");
				          b = IO.Eingabe();
				          datum.setMonat(b);
				          System.out.print("Geben Sie das Jahr an: ");
				          b = IO.Eingabe();
				          datum.setJahr(b);
				          buchung.setDatum(datum);
				          /* Fge die Buchung dem aktiven Konto hinzu */
				          aktivesKonto.buchungHinzufuegen(buchung);
				        } break;
				case 4: { /* Druckt einen Kontoauszug des aktiven Kontos */
						aktivesKonto.druckeBuchungsliste();
				        } break;
				case 5: { /* Listet die Anzahl der verwalteten Konten */
						System.out.println("Anzahl verwalteter Konten: " + Konto.anzahlKonten());
				        } break;						
				case 6: { } break;
				default: { /* Default-Fall, wenn eine ungltige Auswahl getroffen wurde */
						 System.out.println("Ungueltige Auswahl!");	}
			}
		}
	}
}