package figurenanzeige.gui;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import figurenanzeige.figuren.*;

/* Diese Klasse erzeugt ein Fenster, welches geometrische Figuren graphisch anzeigt.
 * Autor: Thomas von der Maen
 * Umgebung: JDK 1.3.1, Windows 2000
 * Erstellt: 14.01.2002
 */
public class Anzeige extends JFrame {
	
	private JPanel p;
	final Color bg = Color.lightGray;
    final Color fg = Color.black;
    
    private GeoObjekt[] figs;
	
	/** Dieser Konstrukor erhlt als Parameter ein Array mit gemetrischen Figuren, die
	  * dargestellt werden sollen.
	  * @param figuren Array mit geometrischen Objekten
	  */
	public Anzeige(GeoObjekt[] figuren) {
		// Aufruf des super-Kontruktors und setzen der Titelleiste
		super("Anzeige der graphischen Figuren");
		this.addWindowListener(new WindowAdapter() {
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
		
		// Kopieren des Arrays mit geometrischen Figuren
		figs = figuren;
		
		// Erzeugung und Layout des Fensters
        p = new JPanel();
        JPanel labelPanel = new JPanel();
        JLabel stat = new JLabel("Gesamtflche: " + String.valueOf(statistik(figs)));
        labelPanel.add(stat);
        //Initialize drawing colors, border, opacity.
        p.setBackground(bg);
        p.setForeground(fg);
        p.setBorder(BorderFactory.createCompoundBorder(
        BorderFactory.createRaisedBevelBorder(),
        BorderFactory.createLoweredBevelBorder()));
        
        this.getContentPane().add(p, BorderLayout.CENTER);
        this.getContentPane().add(labelPanel, BorderLayout.SOUTH);
        this.setSize(new Dimension(800, 600));
        this.setVisible(true);
        
	}
	
	/** Prft, die als String bergebene Farbe und gibt ein Color-Objekt dieser
	  * Farbe zurck.
	  * @param farbe Farbe als String
	  * @return Color-Objekt
	  */
	public Color testeFarbe(String farbe) {
		Color c;
		
		if (farbe.equals("blau")) {
			c = Color.blue;
		}
		else if (farbe.equals("rot")) {
			c = Color.red;
		}
		else if (farbe.equals("gelb")) {
			c = Color.yellow;				
		}
		else if (farbe.equals("gruen")) {
			c = Color.green;				
		}
		// sonst wird die Farbe auf schwarz gesetzt
		else {
			c = Color.black;
		}
		return c;
	}
	
	/**
	 * Berechnet die Gesamtflche aller in feld gespeicherten geometrischen Figuren zurck.
	 * @param feld Array mit geometrischen Figuren
	 * @return Gesamtflche
	 */
	public double statistik(GeoObjekt[] feld) {
		GeoObjekt o;
		
		double gesamtflaeche = 0;
		int i = 0;
		
		while (feld[i] != null && i < figs.length) {
			o = figs[i];
			/* Prfe die enthaltenen Objekte auf deren Typ hin.
			 * Dabei ist die Reihenfolge wichtig, da ein Objekt einer Unterklasse auch
			 * ein Objekt der Oberklasse ist.
			 */
			if (o instanceof Quadrat) {
				// wenn Objekt ein Quadrat
				gesamtflaeche = gesamtflaeche + o.berechneFlaecheninhalt();
			}
			else if (o instanceof Rechteck) {
				// wenn Objekt ein Rechteck
				gesamtflaeche = gesamtflaeche + o.berechneFlaecheninhalt();
			}
			else if (o instanceof Kreis) {
				// wenn Objekt ein Kreis
				gesamtflaeche = gesamtflaeche + o.berechneFlaecheninhalt();
			}
			else if (o instanceof Ellipse) {
				// wenn Objekt eine Ellipse
				gesamtflaeche = gesamtflaeche + o.berechneFlaecheninhalt();
			}
			else {
				System.out.println("Kein GeoObjekt");
			}
			i = i + 1;
		}
		return gesamtflaeche;
	}
		
	// Zeichnet die geometrischen Figuren in dem Fenster
	public void paint(Graphics g) {
        super.paint(g);      //clears the background
        Color fg3D = Color.lightGray;

		Rechteck r;
		Quadrat q;
		Ellipse e;
		Kreis k;
		int x;
		int y;
		Color l = Color.black;
		Color f = Color.black;
		
		int i = 0;

		// SOlange noch Figuren enthalten sind oder die Array-Grenze erreicht ist		
		while (figs[i] != null && i < figs.length) {
			// Speichern der Position
			x = figs[i].getX();
			y = figs[i].getY();
			// Speichern der Farbe
			f = testeFarbe(figs[i].getFuellfarbe());
			l = testeFarbe(figs[i].getLinienfarbe());
							
			if (figs[i] instanceof Quadrat) {
				// Quadrat zeichnen
				q = (Quadrat)figs[i];
				g.setColor(f);
				g.fillRect(q.getX(), q.getY(), (int)q.getSeitenlaenge(), (int)q.getSeitenlaenge());
				g.setColor(l);
				g.drawRect(q.getX(), q.getY(), (int)q.getSeitenlaenge(), (int)q.getSeitenlaenge());
			}
			if (figs[i] instanceof Rechteck) {
				// Rechteck zeichnen
				r = (Rechteck)figs[i];
				g.setColor(f);
				g.fillRect(r.getX(), r.getY(), (int)r.getLaenge(), (int)r.getBreite());
				g.setColor(l);
				g.drawRect(r.getX(), r.getY(), (int)r.getLaenge(), (int)r.getBreite());
			}
			if (figs[i] instanceof Kreis) {
				// Kreis zeichnen
				k = (Kreis)figs[i];
				g.setColor(f);
				g.fillOval(k.getX(), k.getY(), (int)k.getRadius(), (int)k.getRadius());
				g.setColor(l);
				g.drawOval(k.getX(), k.getY(), (int)k.getRadius(), (int)k.getRadius());
			}
			if (figs[i] instanceof Ellipse) {
				// Ellipse zeichnen
				e = (Ellipse)figs[i];
				g.setColor(f);
				g.fillOval(e.getX(), e.getY(), (int)e.getRadiusA(), (int)e.getRadiusB());
				g.setColor(l);
				g.drawOval(e.getX(), e.getY(), (int)e.getRadiusA(), (int)e.getRadiusB());
			}
			i = i + 1;
		}
    }
}
