package figurenanzeige.figuren;

/* Die Klasse realisiert ein Rechteck und stellt spezifische Attribute
 * und Operationen (Methoden) fr ein Rechteck bereit.
 * Autor: Thomas von der Maen
 * Umgebung: JDK 1.3.1, Windows 2000
 * Erstellt: 14.01.2002
 */
 
import figurenanzeige.IO;

public class Rechteck extends Polygon {
	
	protected double laenge;
	protected double breite;
	
	/**
	 * Standardkonstruktor, der alle Attribute initialisiert.
	 */
	public Rechteck() {
		super(4);
		laenge = 0;
		breite = 0;
	}
	
	/**
	 * Konstruktor der das Rechteck mit Lnge und Breite initialisiert
	 * @param laenge Lnge des Rechtecks
	 * @param breite Breite des Rechtecks
	 */
	public Rechteck(double laenge, double breite) {
		super(4);
		pruefeSeitenlaengen(laenge, breite);
	}
	
	/**
	 * Die Methode <i>berechneFlaecheninhalt</i> liefert den Flcheninhalt
	 * des Rechtecks zurck.
	 * @return Flcheninhalt des Rechtecks
	 */
	public double berechneFlaecheninhalt() {
		flaecheninhalt = laenge * breite;
		return flaecheninhalt;
	}
	
	/**
	 * Die Methode <i>berechneUmfang</i> liefert den Umfang
	 * des Rechtecks zurck.
	 * @return Umfang des Rechtecks
	 */
	public double berechneUmfang() {
		umfang = 2 * laenge + 2 * breite;
		return umfang;
	}
	
	/**
	 * Die Methode <i>setSeitenlaengen</i> legt die Seitenlngen
	 * des Rechtecks fest.
	 * @param laenge Laenge des Rechtecks
	 * @param breite Breite des Rechtecks
	 */
	public void setSeitenlaengen(double laenge, double breite) {
		// Prfe, ob Seitenlngen gltig sind
		pruefeSeitenlaengen(laenge, breite);	
	}
	
	/**
	 * Die Methode <i>pruefeSeitenlaengen</i> berprft, ob gltige
	 * Seitenlngen fr ein Rechteck gesetzt wurden.
	 * @param a Seite a des Rechtecks
	 * @param b Seite b des Rechtecks
	 */
	public void pruefeSeitenlaengen(double a, double b) {
		// Seitenlngen mssen positiv Null sein
		if (a > 0 && b > 0) {
			laenge = a;
			breite = b;
		}
		// sonst Initialisierung mit 0
		else {
			laenge = 0;
			breite = 0;
			System.out.println("Keine gueltigen Seitenlaengen. Die Seitenlaengen wurden mit 0 initialisiert.");
		}
	}
	
	/**
	 * Die Methode <i>getLanege</i> liefert die Lnge
	 * des Rechtecks zurck.
	 * @return Lnge
	 */
	public double getLaenge() {
		return laenge;
	}
	
	/**
	 * Die Methode <i>getBreite</i> liefert die Breite
	 * des Rechtecks zurck.
	 * @return Breite
	 */
	public double getBreite() {
		return breite;
	}
	
	/**
	 * Die Methode <i>aenderung</i> liest die Attribute
	 * des Rechtecks durch den Benutzer ein
	 */
	public void aenderung() {
		// Aufruf der aenderung()-Methode der Klasse GeoObjekt
		super.aenderung();
		System.out.print("Geben Sie bitte die Laenge des Rechtecks ein: ");
		double l = IO.DoubleEingabe();
		System.out.print("Geben Sie bitte die Breite des Rechtecks ein: ");
		double b = IO.DoubleEingabe();
		setSeitenlaengen(l, b);
	}
}