package figurenanzeige.figuren;

/* Die Klasse realisiert einen Kreis und stellt spezifische Attribute
 * und Operationen (Methoden) fr einen Kreis bereit.
 * Autor: Thomas von der Maen
 * Umgebung: JDK 1.3.1, Windows 2000
 * Erstellt: 14.01.2002
 */
 
import figurenanzeige.IO;

public class Kreis extends Ellipse {
	
	/**
	 * Standardkonstruktor, der alle Attribute initialisiert.
	 */
	public Kreis() {
		super();
	}
	
	/**
	 * Konstruktor der den Kreis mit dem bergebenen Radius initialisiert
	 * @param radius Radius des Kreises
	 */
	public Kreis(double radius) {
		super(radius, radius);
	}
	
	/**
	 * Die Methode <i>setRadius</i> legt den Radius
	 * des Kreises fest.
	 * @param radius adius des Kreises
	 */
	public void setRadius(double radius) {
		setRadien(radius, radius);
	}
	
	/**
	 * Die Methode <i>getRadiuse</i> liefert den Radius des Kreises
	 * @return Radius des Kreises
	 */
	public double getRadius() {
		return radiusA;
	}
	
	/**
	 * Die Methode <i>pruefeRadien</i> berprft, ob gltige
	 * Radien fr einen Kreis gesetzt wurden.
	 * @param a Radius a der Ellipse
	 * @param b Radius b der Ellipse
	 */
	public void pruefeRadien(double a, double b) {
		// Die Radien mssen gleich und positiv sein
		if (a == b && a > 0 && b > 0) {
			radiusA = a;
			radiusB = b;
		}
		// sonst Initialisierung mit 0
		else {
			radiusA = 0;
			radiusB = 0;
			System.out.println("Die angegebenen Radien entsprechen keinem Kreis! Die Radien wurden mit 0 initialisiert!");
		}
	}
	
	/**
	 * Die Methode <i>aenderung</i> liest die Attribute
	 * des Kreises durch den Benutzer ein
	 */
	public void aenderung() {
		System.out.print("Geben Sie bitte die x-Position ein: ");
		int xpos = IO.Eingabe();
		System.out.print("Geben Sie bitte die y-Position ein: ");
		int ypos = IO.Eingabe();
		setPosition(xpos, ypos);
		System.out.print("Geben Sie bitte die Linienfarbe ein: ");
		String farbe = IO.TextEingabe();
		setLinienfarbe(farbe);
		System.out.print("Geben Sie bitte die Fuellfarbe ein: ");
		farbe = IO.TextEingabe();
		setFuellfarbe(farbe);
		System.out.print("Geben Sie bitte den Radius des Kreises ein: ");
		double r = IO.DoubleEingabe();
		setRadius(r);
	}
	
}