package figurenanzeige.figuren;

/* Die Klasse realisiert ein geometrisches Objekt und stellt spezifische Attribute
 * und Operationen (Methoden) fr solch ein Objekt bereit.
 * Autor: Thomas von der Maen
 * Umgebung: JDK 1.3.1, Windows 2000
 * Erstellt: 14.01.2002
 */
 
import figurenanzeige.IO;

public abstract class GeoObjekt {
	protected double flaecheninhalt;
	protected double umfang;
	protected String linienfarbe;
	protected String fuellfarbe;
	protected int x;
	protected int y;
	
	/**
	 * Standardkonstruktor, der alle Attribute initialisiert.
	 */
	public GeoObjekt() {
		flaecheninhalt = 0;
		umfang = 0;
		linienfarbe = "";
		fuellfarbe = "";
		x = 0;
		y = 0;
	}
	
	/**
	 * Konstruktor der das Objekt mit einer x- und y-Position initialisiert
	 * @param x x-Koordinate des Objekts
	 * @param y y-Koordinate des Objekts
	 */
	public GeoObjekt(int x, int y) {
		flaecheninhalt = 0;
		umfang = 0;
		linienfarbe = "";
		fuellfarbe = "";
		this.x = x;
		this.y = y;
	}
	
	/**
	 * Die Methode <i>setPosition</i> legt die Koordinaten des Objekts fest.
	 * @param x x-Koordinate des Objekts
	 * @param y y-Koordinate des Objekts
	 */
	public void setPosition(int x, int y) {
		this.x = x;
		this.y = y;
	}
	
	public int getX() {
		return x;
	}
	
	public int getY() {
		return y;
	}

	/**
	 * Die Methode <i>berechneFlaecheninhalt</i> ist abstrakt definiert, da noch zu wenige Informationen bekannt sind, um diesen zu berechnen.
	 * @return Flaecheninhalt
	 */
	public abstract double berechneFlaecheninhalt();

	/**
	 * Die Methode <i>berechneUmfang</i> ist abstrakt definiert, da noch zu wenige Informationen bekannt sind, um diesen zu berechnen.
	 * @return Umfang
	 */
	public abstract double berechneUmfang();
	
	/**
	 * Die Methode <i>setLinienfarbe</i> legt die Linienfarbe des Objekts fest.
	 * @param farbe Linienfarbe
	 */
	public void setLinienfarbe(String farbe) {
		linienfarbe = farbe;
	}
	
	/**
	 * Die Methode <i>getLinienfarbe</i> liefert die Linienfarbe
	 * des geometrischen Objekts zurck.
	 * @return Linienfarbe
	 */
	public String getLinienfarbe() {
		return linienfarbe;
	}
	
	/**
	 * Die Methode <i>setFuellfarbe</i> legt die Fuellfarbe des Objekts fest.
	 * @param farbe Fllfarbe
	 */
	public void setFuellfarbe(String farbe) {
		fuellfarbe = farbe;
	}
	
	/**
	 * Die Methode <i>getFuellfarbe</i> liefert die Fuellfarbe
	 * des geometrischen Objekts zurck.
	 * @return Fuellfarbe
	 */
	public String getFuellfarbe() {
		return fuellfarbe;
	}
	
	/**
	 * Die Methode <i>aenderung</i> liest die Attribute
	 * des Geometrischen Objekts durch den Benutzer ein
	 */
	public void aenderung() {
		System.out.print("Geben Sie bitte die x-Position ein: ");
		int xpos = IO.Eingabe();
		System.out.print("Geben Sie bitte die y-Position ein: ");
		int ypos = IO.Eingabe();
		setPosition(xpos, ypos);
		System.out.print("Geben Sie bitte die Linienfarbe ein: ");
		String farbe = IO.TextEingabe();
		setLinienfarbe(farbe);
		System.out.print("Geben Sie bitte die Fuellfarbe ein: ");
		farbe = IO.TextEingabe();
		setFuellfarbe(farbe);
	}
}