package figurenanzeige.figuren;

/* Die Klasse realisiert eine Ellipse und stellt spezifische Attribute
 * und Operationen (Methoden) fr eine Ellipse bereit.
 * Autor: Thomas von der Maen
 * Umgebung: JDK 1.3.1, Windows 2000
 * Erstellt: 14.01.2002
 */
 
import figurenanzeige.IO;

public class Ellipse extends GeoObjekt {
	
	protected double radiusA;
	protected double radiusB;
	
	/**
	 * Standardkonstruktor, der alle Attribute initialisiert.
	 */
	public Ellipse() {
		super();
		radiusA = 0;
		radiusB = 0;
	}
	
	/**
	 * Konstruktor der die Ellipse mit den Lngen der beiden Halbachsen initialisiert
	 * @param a Radius a 
	 * @param b Radius b
	 */
	public Ellipse(double a, double b) {
		super();
		pruefeRadien(a, b);
	}
	
	/**
	 * Die Methode <i>pruefeRadien</i> berprft, ob gltige
	 * Radien fr eine Ellipse gesetzt wurden.
	 * @param a Radius a der Ellipse
	 * @param b Radius b der Ellipse
	 */
	public void pruefeRadien(double a, double b) {
		// beide Radien mssen positiv sein
		if (a > 0 && b > 0) {
			radiusA = a;
			radiusB = b;
		}
		// sonst Initialisierung mit 0
		else {
			radiusA = 0;
			radiusB = 0;
			System.out.println("Die Radien sind ungueltig. Die Radien wurden mit 0 initialisiert.");
		}
	}
	
	/**
	 * Die Methode <i>setRadien</i> legt die Radien
	 * der Ellipse fest.
	 * @param laenge Laenge des Rechtecks
	 * @param breite Breite des Rechtecks
	 */
	public void setRadien(double a, double b) {
		// berprfe, ob Radien gltig sind
		pruefeRadien(a, b);
	}
	
	/**
	 * Die Methode <i>berechneFlaecheninhalt</i> liefert den Flcheninhalt
	 * der Ellipse zurck.
	 * @return Flcheninhalt der Ellipse
	 */
	public double berechneFlaecheninhalt() {
		flaecheninhalt = java.lang.Math.PI * radiusA * radiusB;
		return flaecheninhalt;
	}
	
	/**
	 * Die Methode <i>berechneUmfang</i> liefert den Umfang
	 * der Ellipse zurck.
	 * @return Umfang des Ellipse
	 */
	public double berechneUmfang() {
		umfang = java.lang.Math.PI * (3 * (radiusA + radiusB) - java.lang.Math.sqrt((radiusA + 3 * radiusB) * (3 * radiusA + radiusB)));
		return umfang;
	}
	
	/**
	 * Die Methode <i>getRadiusA</i> liefert den Radius a
	 * der Ellipse zurck.
	 * @return RadiusA
	 */
	public double getRadiusA() {
		return radiusA;
	}
	
	/**
	 * Die Methode <i>getRadiusB</i> liefert den Radius b
	 * der Ellipse zurck.
	 * @return RadiusB
	 */
	public double getRadiusB() {
		return radiusB;
	}
	
	/**
	 * Die Methode <i>aenderung</i> liest die Attribute
	 * der Ellipse durch den Benutzer ein
	 */
	public void aenderung() {
		// Aufruf der aenderung()-Methode der Klasse GeoObjekt
		super.aenderung();
		System.out.print("Geben Sie bitte den Radius A der Ellipse ein: ");
		double a = IO.DoubleEingabe();
		System.out.print("Geben Sie bitte den Radius B der Ellipse ein: ");
		double b = IO.DoubleEingabe();
		setRadien(a, b);
	}
}