package figurenanzeige;

/* Diese Klasse stellt ein Menu bereit, welches dem Benutzer erlaubt verschiedene
 * graphische Figuren anzulegen und in einem Array zu speichern. Diese Figuren werden
 * dann graphisch auf dem Bildschirm in einem Fenster dargestellt.
 * Autor: Thomas von der Maen
 * Umgebung: JDK 1.3.1, Windows 2000
 * Erstellt: 14.01.2002
 */
 
import figurenanzeige.figuren.*;
import figurenanzeige.gui.Anzeige;

public class Figurendarstellung {

	private static int figurenanzahl = 0;
	private static GeoObjekt[] figuren = new GeoObjekt[10];
	
	public static void druckeMenu() {
		System.out.println("*** Figurendarstellung ***");
		System.out.println("1) Rechteck einfuegen");
		System.out.println("2) Quadrat einfuegen");
		System.out.println("3) Ellipse einfuegen");
		System.out.println("4) Kreis einfuegen");
		System.out.println("-------------------------");
		System.out.println("5) Zeichnen");
	}
	
	public static void figurHinzufuegen(GeoObjekt g) {
		if (figurenanzahl < figuren.length) {
			figuren[figurenanzahl] = g;
			figurenanzahl = figurenanzahl + 1;
		}		
	}
			

	public static void main (String[] args) {
		
		/* Menauswahl */
		int auswahl = 0;
				
		for (int i = 0; i < figuren.length; i++) {
			figuren[i] = null;
		}
		
								
		/* Zeige das Menue solange, bis das Programm beendet wird */
		while (auswahl != 5) {
			druckeMenu();
			auswahl = IO.Eingabe();
			switch (auswahl) {
				case 1: { Rechteck r = new Rechteck();
						  r.aenderung();
						  figurHinzufuegen(r);
						  } break;
				case 2: { Quadrat q = new Quadrat();
						  q.aenderung();
						  figurHinzufuegen(q);
						} break;
				case 3: { Ellipse e = new Ellipse();
						  e.aenderung();
						  figurHinzufuegen(e);
						} break;
				case 4: { Kreis k = new Kreis();
						  k.aenderung();
						  figurHinzufuegen(k);
						} break;
				case 5: { Anzeige a = new Anzeige(figuren); } break;
				default: { /* Default-Fall, wenn eine ungltige Auswahl getroffen wurde */
						 System.out.println("Ungueltige Auswahl!");	}
			}
		}
	}
}