{- Loesungsvorschlag zur Uebung "Informatik I - Programmierung"  Blatt 14 -}
---------------------------------------------------------------------------

{- Aufgabe 2 -}

-- (a)
intqsum :: Int -> Int  
intqsum 0 = 0
intqsum x
 | x < 0     = intqsum (-x) 
 | otherwise = (mod x 10) + (intqsum (div x 10))


-- (b)
strqsum :: String -> Int 
strqsum s = listsum (map ord s)
  where
  listsum :: [Int] -> Int
  listsum []     = 0
  listsum (x:xs) = x + listsum xs


-- oder mit Hilfe der (vordefinierten) Funktion foldr,
-- die jedoch nicht in der Vorlesung vorgestellt wurde
strqsum2 :: String -> Int 
strqsum2 x = foldr (+) 0 (map ord x)

-- Definition von foldr:
-- foldr :: (a -> b -> b) -> b -> [a] -> b
-- foldr f z []      = z
-- foldr f z (x:xs)  = f x (foldr f z xs)


-- (c)
data Baum a = Knoten a [Baum a] deriving Show

bmap :: (a -> b) -> Baum a -> Baum b
bmap f (Knoten x []) = Knoten (f x) []
bmap f (Knoten x b)  = Knoten (f x) (map (bmap f) b)


-- Besipiel aus dem Uebungsblatt (b1 dann b2 in hugs eingeben)
b1 = Knoten 4 [Knoten 3 [Knoten 1 [Knoten 2 []]], Knoten 6 [Knoten 5 [], Knoten 7 []]]
b2 = bmap (\x -> 2 * x) b1


---------------------------------------------------------------------------

{- Aufgabe 3 -}

-- (a)
 
-- Ein Eintrag besteht aus einem Wert vom Typ a und der zugehrigen
-- Liste mit Werten vom Typ b.

data Hash a b = Empty | Entry a [b] (Hash a b) deriving Show


-- Beispiel der plz-DB aus dem Uebungsblatt
plz = Entry "Aachen" [52074, 52062, 52064] (Entry "Koeln" [50670, 50679] Empty)


-- (b)

insert :: (Eq a, Eq b) => a -> b -> Hash a b -> Hash a b
-- "(Eq a, Eq b) => ..." in der obigen Typdeklaration bedeutet,
-- dass fuer a und b nur Typen erlaubt sind, die der Klasse
-- Eq (Vergleichbar) angehoeren (wie z.B. Int, Char, String). 
-- Insbesondere sind dann die Vergleichsoperatoren ==, /= vordefiniert.
-- In Analogie zur Java ist Eq wie das Interface Vergleichbar mit
-- den Methoden (==) und (/=).

{- insert:
 - Fuegt einen neuen Eintrag, der aus einem Element e vom Typ a und dem
 - zugehoerigen Wert v vom Typ b besteht, in einer Hash-DB ein.
 - Existiert bereits ein Eintrag e mit dem Wert v, dann bleibt die Hash-DB 
 - unveraendert. Ist ein Eintrag mit dem Element e vorhanden ohne Wert v, 
 - dann wird die Liste der zu e zugeordneten Werte um v erweitert. 
 - Ansonsten wird die Hash-DB um die "Spalte" e mit dem Wert v erweitert.      
 - 
 -}
insert e v Empty = Entry e [v] Empty 
insert e v (Entry x l h)
 | e == x    = Entry x (insert2list v l) h                        
 | otherwise = Entry x l (insert e v h)
   where
   insert2list v [] = [v]
   insert2list v (x:xs)
     | v == x    = (x:xs)
     | otherwise = x : (insert2list v xs)   

-- Alternative Version, die nicht bercksichtigt, ob ein der Wert v bereits zu e
-- existiert, und v zu der Liste der zugeordneten Werten immer hinzufgt.
-- Welche Version man implementiert, war in der Aufgabenstellung freigestellt.

insert2 :: (Eq a, Eq b) => a -> b -> Hash a b -> Hash a b
insert2 e v Empty = Entry e [v] Empty 
insert2 e v (Entry x l h)
 | e == x    = Entry x (v:l) h                        
 | otherwise = Entry x l (insert2 e v h)

 

-- (c)

hmap :: (b -> c) -> Hash a b -> Hash a c
{- hmap:
 - Wendet auf die Werte, die einem Schluessel zugeordnet sind, 
 - eine Funktion an.      
 -}
hmap f Empty = Empty
hmap f (Entry x l h) = Entry x (map f l) (hmap f h)

-- Besipiel aus dem Uebungsblatt (plz und plz2 aufrufen)
plz2 = hmap (\x -> x + 1) plz

---------------------------------------------------------------------------