-- Aufgabe 1

data Nats = Zero | Succ Nats deriving Show 

inf :: Nats
inf = Succ inf

equal :: Nats -> Nats -> Bool
equal Zero Zero =True
equal (Succ a) (Succ b) = (equal a b)
equal _ _ = False

falls :: Bool -> Int -> Int -> Int
falls True x y = x
falls False x y = y

fun1 :: Nats -> Int
fun1 y = falls (equal y Zero) 3 3

fun2 :: Nats -> Int
fun2 y = 3

fun3 :: Nats -> Int
fun3 y = falls (equal y inf) 0 1

fun4 :: Nats -> Int
fun4 (Succ (Succ x)) = 5
fun4 (Succ x) = 3
fun4 Zero = 1


---------------------------------------------------------------

-- Aufgabe 3

fa f = f []

fb f = \x -> f (f x)

fc f []  = []
fc f (x : xs) = (f x) : (fc f xs)

----------------------------------------------------------------

-- Aufgabe 4


-- Datentyp fuer binaere Baeume

data BinTree a = Nil | Node a (BinTree a) (BinTree a) deriving Show

-- Erzeugung einer Liste zur Repraesentation in Infixnotation
-- die Klammersymbole muessen uebergeben werden

toList :: a -> a-> BinTree a -> [a]
toList k1 k2 Nil = []

-- Die Repraesentation des linken Teilbaums, der Wurzel und des rechten Teilbaums werden entsprechend geklammert
-- aneinandergehaengt
-- Die lokal definierte Funktion append haengt zwei Listen aneinander.

toList k1 k2 (Node a t1 t2) = [k1] ++ (toList k1 k2 t1) ++ [k2] ++ [a] ++ [k1] ++ (toList k1 k2 t2) ++ [k2]


-- Alternative Loesung fuer die Erzeugung einer Liste zur Repraesentation in Infixnotation
-- das Symbol fuer den leeren Baum muss uebergeben werden

toList' :: a-> BinTree a -> [a]
toList' nil Nil = [nil]

-- Die Repraesentation des linken Teilbaums, der Wurzel und des rechten Teilbaums werden aneinandergehaengt
-- Die lokal definierte Funktion append haengt zwei Listen aneinander.

toList' nil (Node x t1 t2) = (toList' nil t1) ++  [x] ++  (toList' nil t2)


-- weitere alternative Loesung fuer die Erzeugung einer Liste zur Repraesentation 
-- in Infixnotation
-- [] steht fuer den leeren Baum, jeder Wert im Baum steht in einer
-- Liste der Laenge 1

toList'' :: BinTree a -> [[a]]
toList'' Nil = [[]]

-- Die Repraesentation des linken Teilbaums, der Wurzel und des rechten Teilbaums werden aneinandergehaengt

toList'' (Node x t1 t2) = (toList'' t1)  ++ [[x]] ++  (toList'' t2)


-- Die Funktion lierfert hier einen Durchlauf durch den Baum.
-- Der Binaerbaum ist nicht eindeutig rekonstruierbar aus der Liste.
toList''' :: BinTree a -> [a]
toList''' Nil = []
toList''' (Node x t1 t2) = (toList''' t1)  ++ [x] ++  (toList''' t2)

-- Sortiertes Einfuegen

insert :: BinTree Int -> Int -> BinTree Int

insert Nil z = Node z Nil Nil


-- rekursiver Aufruf mit dem entsprechenen Teilbaum

insert (Node y t1 t2) z | z <= y  = Node y (insert t1 z) t2
                        | otherwise = Node y t1 (insert t2 z)



-- Test auf Enthaltensein

enthalten :: BinTree Int -> Int -> Bool

enthalten Nil z = False


-- rekursives Durchlaufen des Suchbaums

enthalten (Node y t1 t2) z | z == y = True 
                           | z < y  = enthalten t1 z
                           | otherwise = enthalten t2 z


------------------------------------------------------------------------------------

-- Aufgabe 5


-- Datentyp fuer Queues

data Queue a = Empty | Insert a (Queue a) deriving Show




--liefert das erste Element der uebergebenen Queue

firstEl :: Queue a -> a
firstEl (Insert x Empty) = x

-- die Queue wird vom Ende aus durchlaufen, um das erste Element zu erhalten

firstEl (Insert x y) = firstEl y




-- liefert das letzte Element der uebergebenen Queue.

lastEl :: Queue a -> a
lastEl (Insert x y) = x




-- liefert die Queue, die entsteht, wenn man den ersten Wert der uebergebenen Queue loescht.

get :: Queue a -> Queue a

-- Loeschen

get (Insert x Empty) = Empty

-- die Queue wird vom Ende aus durchlaufen, um zum ersten Element zu gelangen

get (Insert x y) = Insert x (get y)




-- liefert die Queue, die entsteht, wenn man den uebergebenen Wert am Ende der uebergebenen Queue hinzufuegt.

add :: Queue a -> a -> Queue a
add q v = Insert v q




-- liefert die Queue, die entsteht, wenn man alle Vorkommen eines uebergebenen Wertes aus der uebergebenen Queue loescht

del :: Queue a -> a -> (a -> a -> Bool) -> Queue a
del Empty v eq  = Empty 

-- die Queue wird durchlaufen und jeder enthaltene Wert wird mit dem uebergebenen Wert bzgl. eq verglichen. Bei 
-- Gleichheit wird der Wert geloescht.

del (Insert x q) v eq | eq x v  = del q v eq
                      | otherwise = Insert x (del q v eq)


