/* Die Klasse realisiert ein Konto und stellt spezifische Attribute
 * und Operationen (Methoden) fr ein Konto bereit bereit.
 * Autor: Thomas von der Maen
 * Umgebung: JDK 1.3.1, Windows 2000
 * Erstellt: 16.11.2001
 */

public class Konto {
	
	private final int maxBuchungen = 100;
	
	private String inhaber;
	private String kontonr;
	private String blz;
	
	private Buchungsliste buchungen = new Buchungsliste();
	
	/* Speicherung der Anzahl der instantiierten Konten */
	private static int anzKonten = 0;
	
	public Konto() {
		init();
		anzKonten = anzKonten + 1;
	}
	
	public Konto(String inhaber, String kontonr, String blz) {
		this.inhaber = inhaber;
		this.kontonr = kontonr;
		this.blz = blz;
		anzKonten = anzKonten + 1;
	}
	
	/* Initialisierung eines neuen Kontos */
	public void init() {
		inhaber = "";
		kontonr = "";
		blz = "";
	}
	
	/* Setzt den Inhaber auf den bergebenen String i */
	public void setInhaber(String i) {
		inhaber = i;
	}
	
	/* Liefert den Inhaber des Kontos zurck */
	public String getInhaber() {
		return inhaber;
	}
	
	/* Setzt die Kontonummer auf den bergebenen String k */
	public void setKontonr(String k) {
		kontonr = k;
	}
	
	/* Liefert die Kontonummer des Kontos zurck */
	public String getKontonr() {
		return kontonr;
	}
	
	/* Setzt die Bankleitzahl auf den bergebenen String b */
	public void setBLZ(String b) {
		blz = b;
	}
	
	/* Liefert die Bankleitzahl des Kontos zurck */
	public String getBLZ() {
		return blz;
	}
	
	/* Fgt eine Buchung in die Buchungsliste hinzu */
	public void buchungHinzufuegen(Buchung b) {
		buchungen.fuegeSortiertEin(b);
		
	}
	
	/* Listet alle gespeicherten Buchungen auf dem Bildschirm auf */
	public void druckeBuchungsliste() {
		Datum d;
		Buchung b;
		double saldo;
		// Audruck der Buchungsliste von vorne nach hinten
		if (buchungen.getAnzahlBuchungen() > -1) {
			System.out.println("Inhaber: "+ inhaber + " BLZ: " + 
			     blz + " Kontonummer: " + kontonr);
			System.out.println("*** Gespeicherte Buchungen ***");
			// Rufe drucke()-Methode der Klasse Buchungsliste auf
			buchungen.drucke();
			System.out.println("Saldo: " + berechneSaldo());
			
			// Und jetzt rckwrts !!!
			System.out.println("*** Gespeicherte Buchungen ***");
			buchungen.druckerueck();
		}
	}
	
	/* Berechnet den Saldo des Kontos */
	public double berechneSaldo() {
		return buchungen.berechneSaldo();			
	}
	
	/* Gibt die Anzahl der instantiierten Konten zurck */
	public static int anzahlKonten() {
		return anzKonten;
	}
}