/* Die Klasse realisiert ein doppelt-verkette Liste um Buchungselemente
 * zu speichern. Ebenso werden Operationen (Methoden) fr die Arbeit auf
 * dieser Liste zur Verfgung gestellt.
 * Autor: Thomas von der Maen
 * Umgebung: JDK 1.3.1, Windows 2000
 * Erstellt: 18.12.2001
 */
public class Buchungsliste {
	
	private Buchungselement kopf;
	private Buchungselement schluss;
	private int anzahlBuchungen;
	
	/* Erzeugt eine neue initialisierte Buchungsliste */
	public Buchungsliste() {
		kopf = schluss = null;
		anzahlBuchungen = 0;
	}
	
	/* Fgt eine Buchung sortiert an der richtigen Stelle ein */
	public void fuegeSortiertEin(Buchung b) {
		/* Aufruf der Hilfsmethode der der Listenkopf bergeben wird */
		kopf = fuegeSortiertEin(b, null, kopf);
		anzahlBuchungen = anzahlBuchungen + 1;
	}
	
	/* Fgt rekursiv eine Buchung in die Liste ein */
	private Buchungselement fuegeSortiertEin(Buchung b, Buchungselement vorgaenger, Buchungselement element) {
		/* Element wird an das Ende der Liste angehngt */
		if (element == null) {
			/* Nuer Schluss wird gesetzt */
			schluss = new Buchungselement(b, vorgaenger, null);
			return schluss;
		}
		/* Element wird sortiert in die Liste eingefgt */
		else if (kleinerAls(b.getDatum(), (element.getBuchung()).getDatum())) {
			Buchungselement neu = new Buchungselement(b, vorgaenger, element);
			/* Setzen des Verweises auf den Vorgnger */
			element.prev = neu;
			return neu;
		}
		/* Gehe ein Element weiter und prfe auf Einfgestelle */
		else {
			element.next = fuegeSortiertEin(b, element, element.next);
			return element;
		}
	}

	/* Vergleicht zwei Daten miteinander und gibt true zurck, falls
	   das Datum d1 vor dem Datum d2 liegt */
	private boolean kleinerAls(Datum d1, Datum d2) {
		/* berprfung des Jahres */
		if (d1.getJahr() > d2.getJahr()) {
			return false;
		}
		else if (d1.getJahr() < d2.getJahr()) {
			return true;
		}
		else {
			/* Wenn die Jahre gleich sind, dann berprfung des Monats */
			if (d1.getMonat() > d2.getMonat()) {
				return false;
			}
			else if (d1.getMonat() < d2.getMonat()) {
				return true;
			}
			else {
				/* Wenn auch die Monate gleich sind, dann berprfung des Tags */
				if (d1.getTag() > d2.getTag()) {
					return false;
				}
				else {
					return true;
				}
			}
		}
	}	
	
	/* Liefert die Anzahl der gespeicherten Buchungen in der Liste */
	public int getAnzahlBuchungen() {
		return anzahlBuchungen;
	}
	
	/* Berechnet den Saldo mittels einer Hilfsmethode */
	public double berechneSaldo() {
		return berechneSaldo(kopf);
	}
	
	/* Rekursiver durchlauf durch die Liste und Akkumulation des Saldos */
	private double berechneSaldo(Buchungselement kopf) {
		if (kopf != null) {
			return (kopf.getBuchung().getBetrag() + berechneSaldo(kopf.next));
		}
		else return 0;
	}
	
	/* 	Gibt die gespeicherten Buchungen von vorne nach hinten mittels einer Hilfsmethode aus */
	public void drucke() {
		System.out.println(durchlaufe(kopf));
	}
	
	/* Durchluft rekursiv die Buchungsliste und gibt alle Buchungen aus */
	private String durchlaufe(Buchungselement kopf) {
		if (kopf != null) {
			Buchung b = kopf.getBuchung();
			return ((b.getDatum()).toString() + " " + b.getBeschreibung() + " " + b.getBetrag()) + "\n" + durchlaufe(kopf.next);
		}
		else return "";
	}
	
	/* Gibt die gespeicherten Buchungen von hinten nach vorne mittels einer Hilfsmethode aus */
	public void druckerueck() {
		System.out.println(durchlauferueck(schluss));
	}
	
	/* Durchluft die Buchungsliste von hinten nach vorne und gibt alle Buchungen aus */
	private String durchlauferueck(Buchungselement schluss) {
		if (schluss != null) {
			Buchung b = schluss.getBuchung();
			return ((b.getDatum()).toString() + " " + b.getBeschreibung() + " " + b.getBetrag()) + "\n" + durchlauferueck(schluss.prev);
		}
		else return "";
	}
}