/* Die Klasse realisiert ein Buchungselement einer
 * doppelt-verketten linearen Liste.
 * Autor: Thomas von der Maen
 * Umgebung: JDK 1.3.1, Windows 2000
 * Erstellt: 18.12.2001
 */
public class Buchungselement {
	
	private Buchung b;
	protected Buchungselement next;
	protected Buchungselement prev;
	
	/* Erzeugt ein neues Buchungselement und inititalisiert die Verweise mit null */
	public Buchungselement(Buchung b) {
		this.b = b;
		this.next = null;
		this.prev = null;
	}
	
	/* Erzeugt ein neues Buchungselement und setzt die Verweise auf die bergebenen
	  Vorgnger und Nachfolger */
	public Buchungselement(Buchung b, Buchungselement prev, Buchungselement next) {
		this.b = b;
		this.prev = prev;
		this.next = next;
	}
	
	/* Liefert die Buchung des Listenelements zurck */
	public Buchung getBuchung() {
		return b;
	}
	
	/* Liefert das nchste Buchungselement zurck */
	public Buchungselement getNext() {
		return next;
	}
	
	/* Liefert das vorhergehende Buchungselement zurck */
	public Buchungselement getPrev() {
		return prev;
	}
	
	/* Setzt den Nachfolger des Buchungselements auf next */
	public void setNext(Buchungselement next) {
		this.next = next;
	}
	
	/* Setzt den Vorgnger des Buchungselements auf prev */
	public void setPrev(Buchungselement prev) {
		this.prev = prev;
	}
}