/* Die Klasse realisiert ein Quadrat und stellt spezifische Attribute
 * und Operationen (Methoden) fr ein Quadrat bereit.
 * Autor: Thomas von der Maen
 * Umgebung: JDK 1.3.1, Windows 2000
 * Erstellt: 20.11.2001
 */
public class Quadrat extends Rechteck {
	
	/**
	 * Standardkonstruktor, der alle Attribute initialisiert.
	 */
	public Quadrat() {
		super();
	}
	
	/**
	 * Konstruktor der das Quadrat mit einer Seitenlnge initialisiert
	 * @param laenge Lnge des Rechtecks
	 */
	public Quadrat(double laenge) {
		// Aufruf des super-Konstruktors mit gleicher Lnge und Breite
		super(laenge, laenge);		
	}
	
	/**
	 * Die Methode <i>setSeitenlaenge</i> legt die Seitenlnge
	 * des Quadrats fest.
	 * @param laenge Laenge des Quadrats
	 */
	public void setSeitenlaenge(double laenge) {
		setSeitenlaengen(laenge, laenge);
	}
	
	/**
	 * Die Methode <i>getSeitenlaenge</i> liefert die Seitenlnge des Quadrats
	 * @return Seitenlnge des Quadrat
	 */
	public double getSeitenlaenge() {
		return laenge;
	}

	/**
	 * Die Methode <i>pruefeSeitenlaengen</i> berprft, ob gltige
	 * Seitenlngen fr ein Quadrat gesetzt wurde.
	 * @param a Seite a des Quadrats
	 * @param b Seite b des Quadrats
	 */
	public void pruefeSeitenlaengen(double a, double b) {
		// Die Seiten a und b mssen gleich lang und positiv sein
		if (a == b && a > 0 && b > 0) {
			laenge = a;
			breite = b;
		}
		// sonst Initialisierung mit 0
		else {
			laenge = 0;
			breite = 0;
			System.out.println("Keine angegebenen Seitenlaengen entsprechen keinem Quadrat. Die Seitenlaengen wurden mit 0 initialisiert.");
		}
	}
}