/* Die Klasse realisiert ein Polygon und stellt spezifische Attribute
 * und Operationen (Methoden) fr ein Polygon bereit.
 * Autor: Thomas von der Maen
 * Umgebung: JDK 1.3.1, Windows 2000
 * Erstellt: 20.11.2001
 */
public class Polygon extends GeoObjekt {

	protected int seitenanzahl;
	
	/**
	 * Standardkonstruktor, der alle Attribute initialisiert.
	 */
	public Polygon() {
		super();
		seitenanzahl = 0;
	}
	
	/**
	 * Konstruktor der das Polygon mit einer Seitenanzahl initialisiert
	 * @param seitenzahl Anzahl der Seiten des Polygons
	 */
	public Polygon(int seitenanzahl) {
		super();
		pruefeSeitenanzahl(seitenanzahl);
		
	}
	
	/**
	 * Konstruktor der das Objekt mit einer x-, y-Position und 
	 * einer Seitenanzahl initialisiert
	 * @param x x-Koordinate des Objekts
	 * @param y y-Koordinate des Objekts
	 * @param seitenanzhal Anzahl der Seiten des Polygons
	 */
	public Polygon(int x, int y, int seitenanzahl) {
		super(x, y);
		pruefeSeitenanzahl(seitenanzahl);
	}
	
	/**
	 * Die Methode <i>setSeitenanzahl</i> legt die Anzahl der 
	 * Seiten des Polygons fest.
	 * @param anzahl Anzahl der Seiten des Polygons
	 * @param y y-Koordinate des Objekts
	 */
	public void setSeitenanzahl(int anzahl) {
		seitenanzahl = anzahl;
	}
	
	/**
	 * Die Methode <i>getSeitenanzahl</i> liefert die Anzahl der Seiten des Polygons.
	 * @return Anzahl der Seiten
	 */
	public int getSeitenanzahl() {
		return seitenanzahl;
	}
	
	/**
	 * Die Methode <i>pruefeSeitenanzahl</i> berprft, ob eine gltige
	 * Seitenanzahl fr ein Polygon gesetzt wurde.
	 * @param n Anzahl der Seiten
	 */
	public void pruefeSeitenanzahl(int n) {
		if (n > 2) {
			seitenanzahl = n;
		}
		// Wenn die Seitenzahl ungltig, initialisiere diese mit 0
		else {
			seitenanzahl = 0;
			System.out.println("Keine gueltige seitenanzahl fuer ein Polygon. Die Seitenanzahl wurde mit 0 initialisiert.");
		}
	}
}