/* Testklasse die die gemoetrischen Figuren testet und die Statistikfunktion realisiert.
 * Autor: Thomas von der Maen
 * Umgebung: JDK 1.3.1, Windows 2000
 * Erstellt: 20.11.2001
 */
public class GeoTest {

	/**
	 * Gibt die Anzahl der jeweiligen geometrischen Figuren in dem bergebenem Array aus und
	 * berechnet die Gesamtflche aller Figuren.
	 * @param feld Array mit geometrischen Figuren
	 */
	public static void statistik(GeoObjekt[] feld) {
		GeoObjekt o;
		
		/* Instantiierung eine neuen Feldes, welches die jeweilige Anzahl an geometrischen Figuren speichert.
		 * 0 - # geometrische Objekte, 1 - # Polygone, 2- # Rechtecke, 3 - # Quadrate, 4 - # Dreiecke,
		 * 5 - # Ellipsen, 6 - # Kreise
		 */
		int[] anzahl = new int[7];
		double gesamtflaeche = 0;
		
		// Initialisierung
		for (int i = 0; i < anzahl.length; i++) {
			anzahl[i] = 0;
		}
		
		for (int i = 0; i < feld.length; i++) {
			o = feld[i];
			/* Prfe die enthaltenen Objekte auf deren Typ hin.
			 * Dabei ist die Reihenfolge wichtig, da ein Objekt einer Unterklasse auch
			 * ein Objekt der Oberklasse ist.
			 */
			if (o instanceof Quadrat) {
				// wenn Objekt ein Quadrat
				anzahl[3]++;
				gesamtflaeche = gesamtflaeche + o.berechneFlaecheninhalt();
			}
			else if (o instanceof Rechteck) {
				// wenn Objekt ein Rechteck
				anzahl[2]++;
				gesamtflaeche = gesamtflaeche + o.berechneFlaecheninhalt();
			}
			else if (o instanceof Dreieck) {
				// wenn Objekt ein Dreieck
				anzahl[4]++;
				gesamtflaeche = gesamtflaeche + o.berechneFlaecheninhalt();
			}
			else if (o instanceof Polygon) {
				// wenn Objekt ein Polygon
				anzahl[1]++;
				gesamtflaeche = gesamtflaeche + o.berechneFlaecheninhalt();
			}
			else if (o instanceof Kreis) {
				// wenn Objekt ein Kreis
				anzahl[6]++;
				gesamtflaeche = gesamtflaeche + o.berechneFlaecheninhalt();
			}
			else if (o instanceof Ellipse) {
				// wenn Objekt eine Ellipse
				anzahl[5]++;
				gesamtflaeche = gesamtflaeche + o.berechneFlaecheninhalt();
			}
			else if (o instanceof GeoObjekt) {
				// wenn Objekt ein geometrisches Objekt
				anzahl[0]++;
				gesamtflaeche = gesamtflaeche + o.berechneFlaecheninhalt();
			}
			else 
				System.out.println("Kein GeoObjekt");
		}
		
		System.out.println("Anzahl der jeweiligen geometrischen Objekte: ");
		System.out.println("GeoObjekte: " + anzahl[0]);
		System.out.println("Polygone  : " + anzahl[1]);
		System.out.println("Rechtecke : " + anzahl[2]);
		System.out.println("Quadrate  : " + anzahl[3]);
		System.out.println("Dreiecke  : " + anzahl[4]);
		System.out.println("Ellipsen  : " + anzahl[5]);
		System.out.println("Kreise    : " + anzahl[6]);
		System.out.println();
		System.out.println("Gesamtflaeche: " + gesamtflaeche);
	}


	public static void main (String[] args) {
		// Erzeugt ein paar Beispielobjekte und testet die Methoden
		GeoObjekt[] a = new GeoObjekt[10];
		
		GeoObjekt g = new GeoObjekt();
		Polygon p = new Polygon();
		Rechteck r = new Rechteck();
		Quadrat q = new Quadrat();
		Dreieck d = new Dreieck();
		Ellipse e = new Ellipse();
		Kreis k = new Kreis(10);
		
		// Setzen der Attribute
		r.setSeitenlaengen(5.0, 7.0);
		q.setSeitenlaenge(4.0);
		d.setSeiten(4.0, 5.0, 8.0);
		e.setRadien(6.0, 10.5);		
		k.setRadius(6.83);
		
		// Ausgabe der jeweiligen Flcheninhalte
		System.out.println("Flaeche GeoObjekt: " + g.berechneFlaecheninhalt());
		System.out.println("Flaeche Polygon: " + p.berechneFlaecheninhalt());
		System.out.println("Flaeche Rechteck: " + r.berechneFlaecheninhalt());
		System.out.println("Flaeche Quadrat: " + q.berechneFlaecheninhalt());
		System.out.println("Flaeche Dreieck: " + d.berechneFlaecheninhalt());
		System.out.println("Flaeche Ellipse: " + e.berechneFlaecheninhalt());
		System.out.println("Flaeche Kreis: " + k.berechneFlaecheninhalt());
		
		// Belegung des Arrays
		a[0] = k;
		a[1] = g;
		a[2] = r;
		a[3] = r;
		a[4] = p;
		a[5] = d;
		a[6] = e;
		a[7] = q;
		a[8] = e;
		a[9] = d;
		
		// Aufruf der Statistik
		statistik(a);
	}
}