/* Die Klasse realisiert ein geometrisches Objekt und stellt spezifische Attribute
 * und Operationen (Methoden) fr solch ein Objekt bereit.
 * Autor: Thomas von der Maen
 * Umgebung: JDK 1.3.1, Windows 2000
 * Erstellt: 20.11.2001
 */
public class GeoObjekt {
	protected double flaecheninhalt;
	protected double umfang;
	protected String linienfarbe;
	protected String fuellfarbe;
	protected int x;
	protected int y;
	
	/**
	 * Standardkonstruktor, der alle Attribute initialisiert.
	 */
	public GeoObjekt() {
		flaecheninhalt = 0;
		umfang = 0;
		linienfarbe = "";
		fuellfarbe = "";
		x = 0;
		y = 0;
	}
	
	/**
	 * Konstruktor der das Objekt mit einer x- und y-Position initialisiert
	 * @param x x-Koordinate des Objekts
	 * @param y y-Koordinate des Objekts
	 */
	public GeoObjekt(int x, int y) {
		flaecheninhalt = 0;
		umfang = 0;
		linienfarbe = "";
		fuellfarbe = "";
		this.x = x;
		this.y = y;
	}
	
	/**
	 * Die Methode <i>setPosition</i> legt die Koordinaten des Objekts fest.
	 * @param x x-Koordinate des Objekts
	 * @param y y-Koordinate des Objekts
	 */
	public void setPosition(int x, int y) {
		this.x = x;
		this.y = y;
	}

	/**
	 * Die Methode <i>berechneFlaecheninhalt</i> fragt den Benutzer nach dem Flcheninhalt
	 * des Objekts, da noch zu wenige Informationen bekannt sind, um diesen zu berechnen.
	 * @return Flaecheninhalt
	 */
	public double berechneFlaecheninhalt() {
		System.out.print("Geben Sie den Flaecheninhalt des Objekts an: ");
		flaecheninhalt = IO.DoubleEingabe();
		return flaecheninhalt;
	}

	/**
	 * Die Methode <i>berechneUmfang</i> fragt den Benutzer nach dem Umfang
	 * des Objekts, da noch zu wenige Informationen bekannt sind, um diesen zu berechnen.
	 * @return Umfang
	 */
	public double berechneUmfang() {
		System.out.print("Geben Sie den Umfang des Objekts an: ");
		umfang = IO.DoubleEingabe();
		return umfang;
	}
	
	/**
	 * Die Methode <i>setLinienfarbe</i> legt die Linienfarbe des Objekts fest.
	 * @param farbe Linienfarbe
	 */
	public void setLinienfarbe(String farbe) {
		linienfarbe = farbe;
	}
	
	/**
	 * Die Methode <i>setFuellfarbe</i> legt die Fuellfarbe des Objekts fest.
	 * @param farbe Fllfarbe
	 */
	public void setFuellfarbe(String farbe) {
		fuellfarbe = farbe;
	}
}