/* Die Klasse realisiert ein Dreieck und stellt spezifische Attribute
 * und Operationen (Methoden) fr ein Dreieck bereit.
 * Autor: Thomas von der Maen
 * Umgebung: JDK 1.3.1, Windows 2000
 * Erstellt: 20.11.2001
 */
public class Dreieck extends Polygon {

	protected double seiteA;
	protected double seiteB;
	protected double seiteC;
	
	/**
	 * Standardkonstruktor, der alle Attribute initialisiert.
	 */
	public Dreieck() {
		super(3);
		seiteA = 0;
		seiteB = 0;
		seiteC = 0;		
	}
	
	/**
	 * Konstruktor der das Dreieck mit drei Seitenlngen initialisiert
	 * @param a Seite a des Dreiecks
	 * @param b Seite b des Dreiecks
	 * @param c Seite c des Dreiecks
	 */
	public Dreieck(double a, double b, double c) {
		super(3);
		// berprfe, ob Seitenlngen ein Dreeck bilden
		pruefeSeiten(a, b, c);
	}
	
	/**
	 * Die Methode <i>setSeiten</i> legt die Seiten
	 * des Dreiecks fest.
	 * @param a Seite a des Dreiecks
	 * @param b Seite b des Dreiecks
	 * @param c Seite c des Dreiecks
	 */
	public void setSeiten(double a, double b, double c) {
		pruefeSeiten(a, b , c);
	}
	
	/**
	 * Die Methode <i>berechneFlaecheninhalt</i> liefert den Flcheninhalt
	 * des Dreiecks zurck.
	 * @return Flcheninhalt des Dreiecks
	 */
	public double berechneFlaecheninhalt() {
		double s = berechneUmfang() / 2;
		flaecheninhalt = java.lang.Math.sqrt(s * (s - seiteA) * (s - seiteB) * (s - seiteC));
		return flaecheninhalt;
	}
	
	/**
	 * Die Methode <i>berechneUmfang</i> liefert den Umfang
	 * des Dreiecks zurck.
	 * @return Umfang des Dreiecks
	 */
	public double berechneUmfang() {
		umfang = seiteA + seiteB + seiteC;
		return umfang;
	}
	
	/**
	 * Die Methode <i>pruefeSeiten</i> berprft, ob gltige
	 * Seitenlngen fr ein Dreieck gesetzt wurden, dass bedeutet, ob
	 * die Seiten auch ein Dreieck festlegen
	 * @param a Seite a des Dreiecks
	 * @param b Seite b des Dreiecks
	 * @param c Seite c des Dreiecks
	 */
	private void pruefeSeiten(double a, double b, double c) {
		// Prfen, ob ein gueltiges Dreieck entsteht
		if ((a + b > c) && (a + c > b) && (b + c > a)) {
			seiteA = a;
			seiteB = b;
			seiteC = c;
		}
		// sonst Initialisierung mit 0
		else {
			seiteA = 0;
			seiteB = 0;
			seiteC = 0;
			System.out.println("Unzulaessige Seitenlaengen. Die Seitenlaengen wurden mit 0 initialisiert.");
		}
	}
}