/**
 * Namen und Matrikelnummern der
 * Gruppenmitglieder hier
 */

import java.util.Random;

public class MergeSort {

    // Die zu sortierende Folge
    private int[] A;
	
    // Konstruktor
    public MergeSort(int[] Arr) {
	
        // Setze das zu sortierende Array
        A = Arr;
    
	}
    
	public static int[] randomArray(int size) {
		int[] arr = new int[size];
		Random rand = new Random();
		for (int i = 0; i < size; ++i) {
			arr[i] = rand.nextInt(1000000);
		}
		return arr;
	}
    
    public void sortBinary() {
        // Erster Aufruf
        mergeSortBinary(0, A.length-1);
    }

    public void sortTernary() {
        // Erster Aufruf
        mergeSortTernary(0, A.length-1);
    }
    
    private void mergeSortBinary(int l, int r) {

        if(r > l) {
            
			int m = (r + l) / 2;
			mergeSortBinary(l, m);
			mergeSortBinary(m + 1, r);			
			mergeBinary(l, m + 1, r + 1);
			
        }
    }

    private void mergeBinary(int l, int m, int r) {

		int[] B = new int[r-l];
		
		int i = 0;
		int j = l;
		int k = m;
		
		while (j < m && k < r) {
			if (A[j] <= A[k]) {
				B[i++] = A[j++];
			} else {
				B[i++] = A[k++];
			}
		}
		
		while(j < m) {
			B[i++] = A[j++];
		}
		while(k < r) {
			B[i++] = A[k++];
		}
		for (int t=0; t<r-l; ++t) {
			A[l+t] = B[t];
		}
		
    }

    private void mergeSortTernary(int l, int r) {
			
			if(r > l) {
			            
				int s = Math.max(1, (r - l + 1) / 3);
				mergeSortTernary(l, l + s - 1);
				mergeSortTernary(l + s, l + 2*s - 1);
				mergeSortTernary(l + 2*s,r);
				mergeTernary(l,l + s, l + 2*s, r + 1);

			}
			
    }

    private void mergeTernary(int l, int m1, int m2, int r) {

		int[] B = new int[r-l];
		
		int i = 0;
		int j = l;
		int k = m1;
		int q = m2;
		
		while (j < m1 && k < m2 && q < r) {
			if (A[j] <= A[k]) {
				if (A[j] <= A[q]) {
					B[i++] = A[j++];
				} else {
					B[i++] = A[q++];
				}
			} else {
				if (A[k] <= A[q]) {
					B[i++] = A[k++];
				} else {
					B[i++] = A[q++];
				}
			}
		}
		
		if (j == m1) {
			j = k;
			k = q;
			m1 = m2;
			m2 = r;
		} else if (k == m2) {
			k = q;
			m2 = r;
		}
		
		while (j < m1 && k < m2) {
			if (A[j] <= A[k]) {
				B[i++] = A[j++];
			} else {
				B[i++] = A[k++];
			}
		}
		
		while (j<m1) {
			B[i++] = A[j++];
		}
		while (k<m2) {
			B[i++] = A[k++];
		}
		for (int t=0; t<r-l; ++t) {
			A[l+t] = B[t];
		}
		
    }

}