
/**
 * Insertion Sort
 * 
 * Namen der Mitglieder und Matrikelnummern hier
 */
public class InsertionSort
{
    // Das Array, das die Daten enthält
    private int[] A;
    
    /**
     * Standard-Konstruktor
     * 
     * Bitte nicht ändern!
     */
    public InsertionSort(int[] B) {
        
        // Kopiere Daten aus B nach A
        A = new int[B.length];
        System.arraycopy(B, 0, A, 0, B.length);
    }
    
    public String print() {
        
        String ret = "[";
        for(int i = 0; i < A.length; ++i) {
            ret += A[i];
            if(i < (A.length-1)) {
                ret += ",";
            }
        }
        ret += "]";
        return ret;
    }
    
    /**
     * Sortiere Array A mit dem Insertion-Sort Verfahren
     */
    public void sort() {

        // Initialisiere Variablen
        int i = 1; // Fange mit zweitem Element an
        int j = -1;
        int h = -1;

        // Gehe mit i von Position 1 bis zum Ende
        while(i < A.length) {

            h = A[i]; // Speichere einzusortierendes Element
            j = i;

            // Suche von rechts die Stelle, an die
            // das Element h geschrieben werden soll
            while(j > 0 && A[j-1] > h) {
                A[j] = A[j-1];
                --j;
            }
            
            // Es gilt nun A[j-1] <= h oder j == 0
            A[j] = h;
            ++i;
        }
    }
}
