import java.util.ArrayDeque;

/**
 * Iterativer Algorithmus zur Loesung von Labyrinthen.
 */
public class Labyrinth {

    /**
     * Ein beispielhaftes Labyrinth, welches einen Zyklus enthaelt.
     */
    char[][] labyrinth;

    /**
     * Die Startposition im obigen Labyrinth.
     */
    Position start;

    /**
     * Die Endposition im obigen Labyrinth.
     */
    Position end;

    public Labyrinth(char[][] labyrinth, Position start, Position end) {
        this.labyrinth = labyrinth;
        this.start = start;
        this.end = end;
    }

    /**
     * Berechnet die Position des Feldes, welches in Richtung r von Feld p
     * liegt.
     */
    private Position Go(Position p, Direction r) {
        switch (r) {
        case N:
            return new Position(p.x, p.y - 1);
        case O:
            return new Position(p.x + 1, p.y);
        case S:
            return new Position(p.x, p.y + 1);
        case W:
            return new Position(p.x - 1, p.y);
        }
        throw new RuntimeException("invalid direction: " + r);
    }

    /**
     * Gibt true zurueck, falls an Position p im Labyrinth ein betretbarer Weg
     * liegt.
     */
    private boolean L(Position p, Direction r) {
        p = Go(p, r);
        if (p.y < 0 || p.y >= labyrinth.length) {
            return false;
        }
        char[] row = labyrinth[p.y];
        if (p.x < 0 || p.x >= row.length) {
            return false;
        }
        return row[p.x] == ' ';
    }

    /**
     * Der iterative Suchalgorithmus der Vorlesung. Diese Methode soll so
     * erweitert werden, dass sie auch auf Labyrinthen funktioniert, welche
     * Zyklen enthalten.
     */
    public ArrayDeque<Direction> sucheIt() {
        Position P = this.start;
        Position Pend = this.end;

        ArrayDeque<Direction> S = new ArrayDeque<Direction>();
        Direction r = Direction.N;

        while (!P.gleich(Pend)
                && (L(P, r) || r.lessThan(Direction.W) || !S.isEmpty())) {
            while (!P.gleich(Pend) && L(P, r)
                    && (S.isEmpty() || r != S.getLast().neg())) {
                S.addLast(r);
                P = Go(P, r);
                r = Direction.N;
            }
            if (!P.gleich(Pend)) {
                while (r == Direction.W && !S.isEmpty()) {
                    r = S.getLast();
                    P = Go(P, r.neg());
                    S.removeLast();
                }
                if (r.lessThan(Direction.W)) {
                    r = r.next();
                }
            }
        }
        return S;
    }
}
